#!/bin/bash

# Train
ID="Pretrain-DRL1"
MODE='train'
CHECKPOINT=null
TEACHER_ENABLE=false
TEACHER_LEARN=false
DOMAIN_RANDOM_FRICTION_CART=true

WITH_FRICTION=true
FRICTION_CART=5
FRICTION_POLE=0

DRL_MAGNITUDE=50

TRAINING_BY_STEPS=true
MAX_TRAINING_STEPS=2e5
RANDOM_SEED=0
TRAIN_RANDOM_RESET=true
EVAL_RANDOM_RESET=true
GAMMA=0

python main.py \
  general.id=${ID} \
  general.mode=${MODE} \
  general.checkpoint=${CHECKPOINT} \
  general.training_by_steps=${TRAINING_BY_STEPS} \
  general.max_training_steps=${MAX_TRAINING_STEPS} \
  cartpole.with_friction=${WITH_FRICTION} \
  cartpole.friction_cart=${FRICTION_CART} \
  cartpole.friction_pole=${FRICTION_POLE} \
  cartpole.random_reset.seed=${RANDOM_SEED} \
  cartpole.random_reset.train=${TRAIN_RANDOM_RESET} \
  cartpole.random_reset.eval=${EVAL_RANDOM_RESET} \
  cartpole.domain_random.friction_cart.apply=${DOMAIN_RANDOM_FRICTION_CART} \
  ha_teacher.teacher_enable=${TEACHER_ENABLE} \
  ha_teacher.teacher_learn=${TEACHER_LEARN} \
  hp_student.phydrl.gamma=${GAMMA} \
  hp_student.agents.action.magnitude=${DRL_MAGNITUDE}